/* whiteLABEL TEN:Q - TEN BAND EQ PLUGIN */
/* http://www.roughdiamondproductions.com/whiteLABEL */

/* Vertex shader */

uniform int NODE;
uniform int DRAWTYPE;
uniform float HUE;
uniform float SATURATION;
uniform float LIGHTNESS;
uniform float FILLALPHA;
uniform float FORCEALPHA;
uniform int MONOCHROME;
uniform int BLEND;
void RGB2HLS(in float red, in float green, in float blue, out float hue, out float saturation, out float lightness){
    float MAX = max(red, green);
    MAX = max(MAX, blue);
    float MIN = min(red, green);
    MIN = min(MIN, blue);
    hue = (MAX + MIN) / 2.0;
    saturation = hue;
    lightness = hue;
    float d;
    if(MAX == MIN){
        saturation = 0.0; // achromatic
        hue = 0.0;
    }else{
	d = MAX - MIN;
	if(lightness > 0.5){
		saturation = d / (2.0 - (MAX - MIN));
	}else{
		saturation = d / (MAX + MIN);
	}
		//saturation = lightness > 0.5 ? saturation = d / (2.0 - (MAX - MIN)) : saturation = d / (MAX + MIN);       
        if(MAX == red){
        	hue = (green - blue) / d + (green < blue ? 6.0 : 0.0);
        }
        if(MAX == green){
        	hue = (blue - red) / d + 2.0;
        }
        if(MAX == blue){
        	hue = (red - green) / d + 4.0;
        }     
        hue /= 6.0;
    }
}

float HUE2RGB(in float p, in float q, in float t){
	
	if(t < 0.0) t += 1.0;
	if(t > 1.0) t -= 1.0;
	if(t < 1.0/6.0) return p + (q - p) * 6.0 * t;
	if(t < 1.0/2.0) return q;
	if(t < 2.0/3.0) return p + (q - p) * (2.0/3.0 - t) * 6.0;
	return p;
}

void HLS2RGB(in float hue, in float saturation, in float lightness, out float red, out float green, out float blue){

	float q;
	float p;

    if(saturation == 0.0){	// achromatic
        red = lightness;
        green = lightness;
        blue = lightness;
    }else{
    	if(lightness < 0.5){
    		q = lightness * (1.0 + saturation);
    	}else{
    		q = lightness + saturation - lightness * saturation;
    	}
	    //q = lightness < 0.5 ? lightness * (1.0 + saturation) : lightness + saturation - lightness * saturation;
        p = 2.0 * lightness - q;
        red = HUE2RGB(p, q, hue + 1.0/3.0);
        green = HUE2RGB(p, q, hue);
        blue = HUE2RGB(p, q, hue - 1.0/3.0);
    }
}

void main(void)
{
	vec4 v = vec4(gl_Vertex); 
	
	vec4 c;
	vec4 c2;

	c2.r=0.0;
	c2.g=0.5;
	c2.b=0.5;
	c2.a=0.7;
	


	// NODE COLOURS :
	switch(NODE){
		case 0:
			c.r = 1.0;
			c.g = 0.0;
			c.b = 0.0;
		break;
		case 1 :
			c.r = 1.0;
			c.g = 0.5;
			c.b = 0.0;
		break;
		case 2 :
			c.r = 1.0;
			c.g = 1.0;
			c.b = 0.0;
		break;
		case 3 :
			c.r = 0.5;
			c.g = 1.0;
			c.b = 0.0;
		break;
		case 4 :
			c.r = 0.0;
			c.g = 1.0;
			c.b = 0.0;
		break;
		case 5 :
			c.r = 0.0;
			c.g = 1.0;
			c.b = 0.5;
		break;
		case 6 :
			c.r = 0.0;
			c.g = 1.0;
			c.b = 1.0;
		break;
		case 7 :
			c.r = 0.0;
			c.g = 0.5;
			c.b = 1.0;
		break;
		case 8 :
			c.r = 0.5;
			c.g = 0.0;
			c.b = 1.0;
		break;
		case 9 :
			c.r = 1.0;
			c.g = 0.0;
			c.b = 1.0;
			c.a = 0.2;
		break;

		default :
			c.r = 1.0;
			c.g = 1.0;
			c.b = 1.0;
			c.a = 1.0;
		break;
	}

	float hue;
	float saturation;
	float lightness;
	float red;
	float green;
	float blue;
	RGB2HLS(c.r,c.g,c.b,hue,saturation,lightness);
	
	saturation *= SATURATION;

	// COLOUR BLEND
	if(DRAWTYPE <= 1){
		if(MONOCHROME == 1){
			hue = HUE;
		}
		if(BLEND == 1 || BLEND == 3){
			if(v.y<0.0){
			hue -= v.y * 0.01;
			}else{
			hue += v.y * 0.01;
			}
			while(hue > 0.5){
				hue -=1.0;
			}
			while(hue < -0.5){
				hue +=1.0;
			}
		}
	}
	
	lightness += LIGHTNESS;
	
	if(DRAWTYPE <= 1){
		if(MONOCHROME == 1){
			if(BLEND == 1 || BLEND == 3){
				HLS2RGB(hue,SATURATION,LIGHTNESS+0.5,red,green,blue);
			}else{
				HLS2RGB(HUE,SATURATION,LIGHTNESS+0.5,red,green,blue);
			}
		}else{
			hue+=HUE;
			HLS2RGB(hue,saturation,lightness,red,green,blue);
		}
	}else{
		HLS2RGB(hue,saturation,lightness,red,green,blue);
	}
	
	c.r = red;
	c.g = green;
	c.b = blue;	
	
	float n;
	// PEN / FILL ALPHA
	switch(DRAWTYPE){
		
		case 0:			// FILL BEHIND NODE
			//c=c2;
			c.a = FILLALPHA;
		break;
		
		case 1:			// NODE OUTLINE
			//c=c2;
			c.a = 1.0;
		break;
		
		case 2:			// MAIN STEREO PLOT, GENERAL WHITE
			c.r = 1.0;
			c.g = 1.0;
			c.b = 1.0;
			c.a = 0.8;
		break;
		
		case 3:			// LEFT PLOT
			c.r = 1.0;
			c.g = 1.0;
			c.b = 0.0;
			c.a = 0.8;
			//	RGB2HLS(c.r,c.g,c.b,hue,saturation,lightness);
			//	HLS2RGB(hue+HUE,saturation*SATURATION,lightness+LIGHTNESS,red,green,blue);
			//c.r = red;
			//c.g = green;
			//c.b = blue;
		break;
		
		case 4:			// RIGHT PLOT
			c.r = 0.0;
			c.g = 1.0;
			c.b = 0.0;
			c.a = 0.8;
		break;
		
		case 5:			// MID PLOT
			c.r = 1.0;
			c.g = 0.0;
			c.b = 1.0;
			c.a = 0.8;
		break;
		
		case 6:			// SIDE PLOT
			c.r = 0.0;
			c.g = 1.0;
			c.b = 1.0;
			c.a = 0.8;
		break;
		case 10:
			c.a = 0.5;
		break;
		
		
		case 20:		// CIRCLE INNER STEREO
			c.r = 1.0;
			c.g = 1.0;
			c.b = 1.0;
			c.a = 1.0;
		break;
		
		case 21:		// CIRCLE INNER LEFT
			c.r = 1.0;
			c.g = 1.0;
			c.b = 0.0;
			c.a = 1.0;
		break;
		
		case 22:		// CIRCLE INNER RIGHT
			c.r = 0.0;
			c.g = 1.0;
			c.b = 0.0;
			c.a = 1.0;
		break;
		
		case 26:		// CIRCLE WHITE
		case 23:
		c.r = 1.0;
			c.g = 1.0;
			c.b = 1.0;
			c.a = 1.0;
		break;
		
		case 24:		// CIRCLE INNER MID
			c.r = 1.0;
			c.g = 0.0;
			c.b = 1.0;
			c.a = 1.0;
		break;
		
		case 25:		// CIRCLE INNER SIDE
			c.r = 0.0;
			c.g = 1.0;
			c.b = 1.0;
			c.a = 1.0;
		break;

		case 30:		// GRIDS
			c.r=1.0;
			c.g=1.0;
			c.b=1.0;
			c.a=0.1;
		break;
		case 31:		// SPECTRUM DIFFERENCE
			c.r=1.0;
			c.g=1.0;
			c.b=1.0;
			c.a=1.0;
		break;
		
		case 12:		// BLACK CIRCLE BUFFER
			c.r = 0.0;
			c.g = 0.0;
			c.b = 0.0;
			c.a = 0.9;
		break;
		case 50:		// DISPLAY BACKGROUND
			c.r = 0.3;
			c.g = 0.3;
			c.b = 0.3;
			c.a = 0.1;
		break;
		
		case 2000:		// BUTTON OFF
			c.r = 0.16;
			c.g = 0.3;
			c.b = 0.3;
			c.a = 1.0;
		break;
		case 2001:		// BUTTON ON
			c.r = 0.32;
			c.g = 0.83;
			c.b = 0.83;
			c.a = 1.0;
		break;
		case 2002:		// BUTTON ON 2
			c.r = 0.36;
			c.g = 1.0;
			c.b = 1.0;
			c.a = 1.0;
		break;
		case 1000:
			c.r = 1.0;
			c.g = 1.0;
			c.b = 1.0;
			c.a = 1.0;
		break;
		case 1001:		// SPECTRUM LEFT IN TRUE STEREO MODE
			if(MONOCHROME == 1){
				HLS2RGB(HUE,SATURATION,LIGHTNESS+0.5,red,green,blue);
				c.a = 0.2;
			}else{
				c.r = 1.0;
				c.g = 1.0;
				c.b = 0.0;
				c.a = 0.2;
				RGB2HLS(c.r,c.g,c.b,hue,saturation,lightness);
				hue -= v.y * 0.02;
				HLS2RGB(hue,saturation,lightness,red,green,blue);
			}

			c.r = red;
			c.g = green;
			c.b = blue;

			c.r = 0.5;
			c.g = 0.0;
			c.b = 1.0;
			c.a = 0.5;
		break;
		case 1002:		// SPECTRUM RIGHT IN TRUE STEREO MODE
			if(MONOCHROME == 1){
				HLS2RGB(HUE+0.5,SATURATION,LIGHTNESS+0.5,red,green,blue);
				c.a = 0.2;
			}else{
				c.r = 0.0;
				c.g = 1.0;
				c.b = 0.0;
				c.a = 0.2;
				RGB2HLS(c.r,c.g,c.b,hue,saturation,lightness);
				hue -= v.y * 0.02;
				hue += 0.5;
				HLS2RGB(hue,saturation,lightness,red,green,blue);
			}
	
			c.r = red;
			c.g = green;
			c.b = blue;

			c.r = 0.0;
			c.g = 1.0;
			c.b = 0.5;
			c.a = 0.5;
		break;
		case 1003:		// SPECTRUM LEFT IN SPLIT STEREO MODE
			c.r = 1.0;
			c.g = 1.0;
			c.b = 0.0;
			c.a = 0.5;
		break;
		case 1004:		// SPECTRUM RIGHT IN SPLIT STEREO MODE
			c.r = 0.0;
			c.g = 1.0;
			c.b = 0.0;
			c.a = 0.5;
		break;
		case 1005:		// SPECTRUM MID
			c.r = 1.0;
			c.g = 0.0;
			c.b = 1.0;
			c.a = 0.5;
		break;
		case 1006:		// SPECTRUM SIDE
			c.r = 0.0;
			c.g = 1.0;
			c.b = 1.0;
			c.a = 0.5;
		break;
		case 1007:		// SPECTRUM INPUT MONO
			c.r = 1.0;
			c.g = 0.0;
			c.b = 0.0;
			c.a = 0.5;
		break;
		case 1008:		// SPECTRUM OUTPUT MONO
			c.r = 0.0;
			c.g = 0.0;
			c.b = 1.0;
			c.a = 0.5;
		break;
		case 1009:		// SPECTRUM OUTPUT LEFT
			c.r = 1.0;
			c.g = 0.5;
			c.b = 0.0;
			c.a = 0.5;
		break;
		case 1010:		// SPECTRUM OUTPUT RIGHT
			c.r = 0.0;
			c.g = 0.5;
			c.b = 1.0;
			c.a = 0.5;
		break;
		case 3000:		// OUTPUT VU - LOGO
			c.r = 1.0;
			c.g = 1.0;
			c.b = 1.0;
			c.a = LIGHTNESS;	// LIGHTNESS HIJACKED FOR ALPHA CHANNEL
		break;
		case 3001: // OUTPUT VU - LOGO CLIPPING
			c.r = 1.0;
			c.g = 0.0;
			c.b = 0.0;
			c.a = LIGHTNESS;	// LIGHTNESS HIJACKED FOR ALPHA CHANNEL
		break;
		case 3002:		// MOUSE HIGHLIGHT SQUARE (STEREO)
			c.r = 1.0;
			c.g = 1.0;
			c.b = 1.0;
			c.a = 1.0;
		break;
		case 3003:		// MOUSE HIGHLIGHT L (SPLIT STEREO)
			c.r = 1.0;
			c.g = 1.0;
			c.b = 0.0;
			c.a = 1.0;
		break;
		case 3004:		// MOUSE HIGHLIGHT R (SPLIT STEREO)
			c.r = 0.0;
			c.g = 1.0;
			c.b = 0.0;
			c.a = 1.0;
		break;
		case 3005:		// MOUSE HIGHLIGHT M
			c.r = 1.0;
			c.g = 0.0;
			c.b = 1.0;
			c.a = 1.0;
		break;
		case 3006:		// MOUSE HIGHLIGHT S
			c.r = 0.0;
			c.g = 1.0;
			c.b = 1.0;
			c.a = 1.0;
		break;
		
		default :
			c.a = 0.5;
		break;
	}
	switch(DRAWTYPE){
		
		case 11:		// PHASE MAIN STEREO PLOT
			c.r = 1.0;
			c.g = 0.0;
			c.b = 0.0;
			c.a = 0.1;
		break;
		
		case 13:		// PHASE LEFT PLOT
			c.r = 1.0;
			c.g = 1.0;
			c.b = 0.0;
			c.a = 0.1;
		break;
		
		case 14:		// PHASE RIGHT PLOT
			c.r = 0.0;
			c.g = 1.0;
			c.b = 0.0;
			c.a = 0.1;
		break;
		
		case 15:		// PHASE MID PLOT
			c.r = 1.0;
			c.g = 0.0;
			c.b = 1.0;
			c.a = 0.1;
		break;
		
		case 16:		// PHASE SIDE PLOT
			c.r = 0.0;
			c.g = 1.0;
			c.b = 1.0;
			c.a = 0.1;
		break;




		case 4002:	// CREDITS BACKDROP
			c.r = 1.0;
			c.g = 1.0;
			c.b = 1.0;
			c.a = 0.5;
		break;
		case 4003:	// BLACKOUT BACKDROP
			c.r = 0.0;
			c.g = 0.0;
			c.b = 0.0;
			c.a = FORCEALPHA;
		break;
	}
	
	gl_Position = gl_ModelViewProjectionMatrix * v;  
	//gl_Position = v;
	
	gl_FrontColor = c;
	
	//c.a=0.0;
	//gl_BackColor = c;
	    
}

